package com.example.textwatcher;

import android.text.Editable;
import android.text.TextWatcher;
import android.widget.*;

import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;

import java.util.ArrayList;
import java.util.List;

public class MainActivity extends AppCompatActivity {
    private EditText et;
    private ListView lv;
    private List<String> names;
    private ArrayAdapter<String> adapter;
    private ContainerName containerNames;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        containerNames = new ContainerName();
        lv = (ListView) findViewById(R.id.listView);
        names = new ArrayList<String>();
        adapter = new ArrayAdapter<String>(this, android.R.layout.simple_list_item_1, names);
        lv.setAdapter(adapter);
        et=(EditText)findViewById(R.id.editText);
        et.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                names.clear();
                if(s.length() > 0) {
                    StringBuilder sb = new StringBuilder(s.length());
                    sb.append(s);
                    String text = sb.toString();
                    names.addAll(containerNames.search(text));
                }
                adapter.notifyDataSetChanged();

            }

            @Override
            public void afterTextChanged(Editable s) {





            }
        });
    }
}